/* ARDUINO TACHOMETER BY A. SAMIUDDHIN */

#include <LiquidCrystal.h> // LCD library
LiquidCrystal lcd(8, 7, 6, 5, 4, 3); //LCD diplay pins on Arduino
unsigned int rev=0;

void setup()
{
  Serial.begin(9600);
  lcd.begin(16,2);
  lcd.setCursor(5, 0);
  lcd.print("ARDUINO");
  lcd.setCursor(3, 1);
  lcd.print("TACHOMETER");
  delay(1000);
  attachInterrupt(0,isr,FALLING);  //attaching the interrupt
  lcd.clear();   
}

void loop()
{
  unsigned int rpm = rotation(); //Call "rotation" function
  rev=0;
  delayMicroseconds(1000000); 
  lcd.setCursor(3, 0);
  lcd.print("TACHOMETER");
  lcd.setCursor(0, 1);
  lcd.print("RPM: ");
  lcd.setCursor(5, 1);
  lcd.print(rpm);
  lcd.print("           ");
  Serial.println(rpm);
}

void isr() //interrupt service routine
 {
  rev++;
 }

unsigned int rotation()
  {
  unsigned int r;
  interrupts();        //Enable the interrupt
  delay(1024);
  noInterrupts();     //Disable the interrupt
  r=(rev)*60;         //calculates rpm
  return r;
  }

